/*
 * Decompiled with CFR 0.152.
 */
package de.kxmischesdomi.morebannerfeatures.core.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.kxmischesdomi.morebannerfeatures.MoreBannerFeatures;
import de.kxmischesdomi.morebannerfeatures.core.config.MBFOptions;
import de.kxmischesdomi.morebannerfeatures.core.config.options.IOption;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class MBFConfigManager {
    private static File configFile;
    private static List<IOption> cachedOptions;

    public static void loadConfigFile() {
        if (configFile == null) {
            configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "morebannerfeatures.json");
        }
    }

    public static void load() {
        MBFConfigManager.loadConfigFile();
        try {
            if (!configFile.exists()) {
                MBFConfigManager.save();
            }
            if (configFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(configFile));
                JsonObject json = new JsonParser().parse((Reader)br).getAsJsonObject();
                for (IOption option : MBFConfigManager.getAllOptions()) {
                    option.read(json);
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Couldn't load configuration file");
            exception.printStackTrace();
        }
    }

    public static void save() {
        MBFConfigManager.loadConfigFile();
        JsonObject json = new JsonObject();
        try {
            for (IOption option : MBFConfigManager.getAllOptions()) {
                option.write(json);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        String jsonString = MoreBannerFeatures.GSON.toJson((JsonElement)json);
        try (FileWriter fileWriter = new FileWriter(configFile);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save configuration file");
            e.printStackTrace();
        }
    }

    public static List<IOption> getAllOptions() {
        if (cachedOptions != null && !cachedOptions.isEmpty()) {
            return cachedOptions;
        }
        LinkedList<IOption> options = new LinkedList<IOption>();
        for (Field field : MBFOptions.class.getDeclaredFields()) {
            try {
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers()) || !IOption.class.isAssignableFrom(field.getType())) continue;
                options.add((IOption)field.get(null));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        cachedOptions = options;
        return options;
    }
}

